﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data;
using System.Data.SqlClient;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.Utilities;

namespace AZVIC.Ei8htPOS.DAL
{
    public class LayoutsDB
    {
        public static Layouts GetItem(Guid TableID)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@TableID", ((TableID != Guid.Empty && TableID != null) ? TableID : (object)DBNull.Value)));
            

            return SQLHelper.RetrieveObject<Layouts>("spGetLayouts", parameters);
        }

        public static List<Layouts> GetList(Guid TableID)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@TableID", ((TableID != Guid.Empty && TableID != null) ? TableID : (object)DBNull.Value)));

            return SQLHelper.RetrieveList<Layouts>("spGetLayouts", parameters);
        }

        public static void Save(Layouts NewTable)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            if (NewTable.TableID == Guid.Empty)
            {
                NewTable.TableID = Guid.NewGuid();
                NewTable.IsActive = true;
            }

            parameters.Add(new SqlParameter("@TableID",(NewTable.TableID!=null && NewTable.TableID!=Guid.Empty)? NewTable.TableID : (object)DBNull.Value));
            parameters.Add(new SqlParameter("@TableName", ((NewTable.TableName != null && !string.IsNullOrEmpty(NewTable.TableName)) ? NewTable.TableName : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@TableCapacity", ((NewTable.TableCapacity))));
            parameters.Add(new SqlParameter("@CreatedBy", ((NewTable.CreatedBy != null && NewTable.CreatedBy != Guid.Empty) ? NewTable.CreatedBy : (object)DBNull.Value)));
            parameters.Add(new SqlParameter("@IsActive", NewTable.IsActive));
            parameters.Add(new SqlParameter("@TableType", (string.IsNullOrEmpty(NewTable.TableType) ? (object)DBNull.Value : NewTable.TableType)));
            parameters.Add(new SqlParameter("@TablePosition", (string.IsNullOrEmpty(NewTable.TablePosition) ? (object)DBNull.Value : NewTable.TablePosition)));
            
            SQLHelper.ExecuteQuery("spAddOrUpdateLayout", parameters);
        }

        public static void Delete(Guid TableID)
        {
            List<SqlParameter> parameters = new List<SqlParameter>();
            parameters.Add(new SqlParameter("@TableID", ((TableID != Guid.Empty && TableID != null) ? TableID : (object)DBNull.Value)));

            SQLHelper.ExecuteQuery("spRemoveLayout", parameters);
        }

    }
}
